﻿#using System.Threading.Tasks;
#using Tessa.Cards;

const string justificationSectionAlias = "ExJustification";
const string commentAlias = "Comment";

const string bSend = "Send";
const string mCardFileCategoryName = "Финансовое обоснование";

if(dialog.ButtonName == bSend)
{
	// Перенос комментария из поля "Комментарий к обоснованию" карточки диалога в одноимённое поле карточки СЗ.
	(await this.GetCardObjectAsync()).Sections.GetOrAdd(justificationSectionAlias).Fields[commentAlias] = (await dialog.GetCardObjectAsync()).Sections[justificationSectionAlias].Fields[commentAlias];

	// Перенос файлов приложенных к карточке диалога в карточку СЗ.
	var mCardFileContainer = (await this.Context.GetFileContainerAsync(cancellationToken: this.Context.CancellationToken)).FileContainer;
	var dCardFileContainer = (await dialog.GetFileContainerAsync()).FileContainer;
	
	foreach(var dFile in dCardFileContainer.Files)
	{
		if(!dFile.Content.HasData)
		{
			var result = await dFile.EnsureContentDownloadedAsync(cancellationToken: this.Context.CancellationToken);
			this.ValidationResult.Add(result);
			
			if(result.HasErrors)
			{
				return;
			}
		}
		
		await mCardFileContainer
			.BuildFile(dFile.Name)
			.SetContent(dFile.Content)
			.SetVersionToken(
				(ft, ct) =>
				{
					var lastVersion = dFile.Versions.Last();
					
					ft.Created = lastVersion.Created;
					ft.CreatedByID = lastVersion.CreatedByID;
					ft.CreatedByName = lastVersion.CreatedByName;
					
					ft.Hash = lastVersion.Hash;
					
					return new ValueTask();
				})
			.SetCategory(mCardFileCategoryName)
			.AddWithNotificationAsync(cancellationToken: this.Context.CancellationToken);
	}
}